/*****************************************************************************************
* MATCHING INDIVIDUALS WITHIN A HOUSEHOLD                                                *
* In this example we will match the information of respondents living with               *
* partners/spouses onto that of their partners/spouses.                                  *
*****************************************************************************************/

// change current file location
cd "location:/for/files/you/create"

// assign global macro to refer to Understanding Society data
global ukhls "location:/ukhls/datafiles/are/stored"


// Open data file for all enumerated individuals and select the 
// variables for which you want to create a spouse/partner version
use a_hidp a_pno a_ppno a_sex_dv a_age_dv using "$ukhls/ukhls_w1/a_indall", clear

// Restrict to individuals who have a spouse/partner in the household
// If an individual does not have a partner then a_ppno will be 0,
// if they do have a partner then a_ppno is the pno of their partner
keep if a_ppno>0

// rename all individual characteristics to something that would indicate
// the characteristics refer to the spouse/partner. Here the prefix sp_
// before the variable stem name and preserve the wave prefix
rename a_* a_sp_*

// rename the spouse/partner pno variable to respondent pno for matching to their partner
rename a_sp_ppno a_pno

// rename the hidp back to a_hidp  
rename a_sp_hidp a_hidp

// drop the variable a_sp_pno as it is no longer needed
drop a_sp_pno 

// save the file temporarily
save tmp_spinfo, replace


// reopen data file for all enumerated individuals and keep the same set of variables
use a_hidp a_pno a_ppno a_sex_dv a_age_dv using "$ukhls/ukhls_w1/a_indall", clear

// restrict the variables to individuals who have a spoise/partner in the household
keep if a_ppno>0

// merge the data with the data relating to the spouse/partner, using
// a_hidp and a_pno as linking variables. Note that there SHOULD NOT BE
// any non-matching records, that is, the value of _merge=3 
merge 1:1 a_hidp a_pno using tmp_spinfo

// drop the merge variable otherwise future merges will not work
drop _merge

// save the data file
save spinfo, replace 

// clean up unwanted files
erase tmp_spinfo.dta
